/*
 * Decompiled with CFR 0.152.
 */
package de.archimedon.emps.server.jobs.umbuchungserinnerung;

import de.archimedon.base.util.DateUtil;
import de.archimedon.base.util.Duration;
import de.archimedon.emps.server.base.PersistentEMPSObject;
import de.archimedon.emps.server.dataModel.DataServer;
import de.archimedon.emps.server.dataModel.Person;
import de.archimedon.emps.server.dataModel.meldungen.MeldeTyp;
import de.archimedon.emps.server.dataModel.meldungen.strategie.MeldeStrategie;
import de.archimedon.emps.server.dataModel.meldungen.strategie.Meldungsdatentyp;
import de.archimedon.emps.server.dataModel.meldungen.strategie.XMeldestrategieMeldeTyp;
import de.archimedon.emps.server.dataModel.projekte.ProjektElement;
import de.archimedon.emps.server.dataModel.projekte.arbeitspakete.Arbeitspaket;
import de.archimedon.emps.server.dataModel.stm.StmJobAdapter;
import java.util.Collection;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Umbuchungserinnerung
extends StmJobAdapter {
    private static final Logger log = LoggerFactory.getLogger(Umbuchungserinnerung.class);
    private DataServer server;
    private MeldeTyp meldeTyp;

    public String getDescription() {
        return "Umbuchungserinnerung";
    }

    protected void start(DataServer dataServer, String logPath) {
        this.server = dataServer;
        this.meldeTyp = (MeldeTyp)this.server.getObjectsByJavaConstant(MeldeTyp.class, 38);
        Collection arbeitspaketeList = this.server.getPM().getAllUmbuchungspflichtigeArbeitspakete();
        DateUtil datumHeute = new DateUtil();
        if (DataServer.DEBUG_MODUS_BUCHUNGSERINNERUNG) {
            datumHeute = DataServer.AKTUELLES_DATUM_BUCHUNGSERINNERUNG;
        }
        log.info("+----------------------------------------------------------------------------------------------------------\n");
        log.info(" Job Umbuchungserinnerung gestartet! Datum: " + datumHeute + "\n");
        int apCounter = 0;
        int nullCounter = 0;
        int keineGeleistetenStundenCounter = 0;
        int apvFehltCounter = 0;
        int initiierteMeldungenCounter = 0;
        int size = arbeitspaketeList.size();
        for (Arbeitspaket arbeitspaket : arbeitspaketeList) {
            MeldeStrategie meldeStrategie;
            super.setFortschrittStatus(Integer.valueOf((int)(100.0 * (double)(++apCounter) / (double)size)));
            if (arbeitspaket == null) {
                ++nullCounter;
                continue;
            }
            log.info("Folgedes AP wird gepr\u00fcft: {} {}\n", (Object)arbeitspaket.getNummerFull(), (Object)arbeitspaket.getName());
            Person apv = arbeitspaket.getAPVerantwortlicher();
            Duration geleistet = arbeitspaket.getIstStunden();
            if (geleistet == null || geleistet.getStundenDezimal() == 0.0) {
                ++keineGeleistetenStundenCounter;
                if (arbeitspaket.getUmbuchungserinnerungDatum() != null) {
                    arbeitspaket.setUmbuchungserinnerungDatum(null);
                    arbeitspaket.setIsUmbuchungserinnerungsWiederholung(Boolean.valueOf(false));
                }
                log.info("\tX Keine geleisteten Stunden. Umbuchungserinnerungsdatum zur\u00fcckgesetzt.\n");
                log.info("+---\n");
                continue;
            }
            if (apv == null) {
                ++apvFehltCounter;
                log.info("\tY Kein Arbeitspaketverantwortlicher eingetragen\n");
            }
            if ((meldeStrategie = arbeitspaket.getMeldeStrategie(this.meldeTyp)) == null) {
                meldeStrategie = this.meldeTyp.getMeldeKlasse().getStandardstrategie();
            }
            if (meldeStrategie == null) {
                log.info("\tX Keine Meldestrategie vorhanden\n");
                continue;
            }
            XMeldestrategieMeldeTyp meldestrategieMeldeTyp = meldeStrategie.getXMeldestrategieMeldeTyp(this.meldeTyp);
            if (meldestrategieMeldeTyp == null) {
                log.info("\tX Kein entsprechender XMeldestrategieMeldeTyp vorhanden\n");
                continue;
            }
            boolean meldungSenden = false;
            DateUtil datumDerLetztenErinnerung = arbeitspaket.getUmbuchungserinnerungDatum();
            datumHeute.set(14, 0);
            datumHeute.set(13, 0);
            datumHeute.set(12, 0);
            datumHeute.set(11, 0);
            if (datumDerLetztenErinnerung == null) {
                log.info("\tA Meldung muss neu initiiert werden\n");
                meldungSenden = true;
            } else {
                DateUtil neuesDatum = datumDerLetztenErinnerung.addDay(meldestrategieMeldeTyp.getBeErsteErinnerung().intValue());
                neuesDatum.set(14, 0);
                neuesDatum.set(13, 0);
                neuesDatum.set(12, 0);
                neuesDatum.set(11, 0);
                if (neuesDatum.equals((Object)datumHeute) || neuesDatum.before((Date)datumHeute)) {
                    log.info("\tB Meldungswiederholung muss initiiert werden\n");
                    meldungSenden = true;
                }
            }
            if (meldungSenden) {
                ++initiierteMeldungenCounter;
                boolean isKommendMeldung = true;
                Arbeitspaket quelle = arbeitspaket;
                ProjektElement zuordnung = arbeitspaket.getRootObject();
                Meldungsdatentyp meldungsdatenTyp = Meldungsdatentyp.UMBUCHUNGSERINNERUNG;
                log.info("\t---> Meldungsversand wird initiiert ... \n");
                log.info("\t---> APV: {}\n", (Object)(apv == null ? " - " : apv));
                log.info("\t---> Geleistete Stunden: {}\n", (Object)geleistet.getStundenDezimal());
                log.info("\t---> Zuordnung: {}\n", (Object)zuordnung.getName());
                if (arbeitspaket.getUmbuchungserinnerungDatum() == null) {
                    arbeitspaket.setIsUmbuchungserinnerungsWiederholung(Boolean.valueOf(false));
                } else {
                    arbeitspaket.setIsUmbuchungserinnerungsWiederholung(Boolean.valueOf(true));
                }
                arbeitspaket.setUmbuchungserinnerungDatum((Date)datumHeute);
                this.server.getMeldungsmanagement().createPersonenMeldungenByMeldestrategie(this.meldeTyp, isKommendMeldung, (PersistentEMPSObject)quelle, (PersistentEMPSObject)zuordnung, meldungsdatenTyp, null);
            } else {
                log.info("\t<--- Es muss keine Meldung versendet werden\n");
            }
            log.info("+---\n");
        }
        super.setFortschrittStatus(Integer.valueOf(0));
        this.finished();
        log.info("+--- Anzahl der APs die NULL waren: {} ---+\n", (Object)nullCounter);
        log.info("+--- Anzahl der APs ohne geleistete Stunden: {} ---+\n", (Object)keineGeleistetenStundenCounter);
        log.info("+--- Anzahl der APs ohne APV: {} ---+\n", (Object)apvFehltCounter);
        log.info("+--- Anzahl der Meldungen die initiiert wurden: {} ---+\n", (Object)initiierteMeldungenCounter);
        log.info(" Job Umbuchungserinnerung beendet! Datum: {}\n\n", (Object)new Date());
    }
}

